/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.LogManager;
import oracle.install.driver.oui.LogSafetyChecker;
import oracle.install.driver.oui.OUILogFormatter;
import oracle.install.driver.oui.OUITimeLogHandler;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class OUILogHandler
extends Handler {
    private static final Formatter OUI_LOG_FORMATTER = new OUILogFormatter();
    private static final HashMap<Level, Integer> mapping = new HashMap();
    private static File logFile;
    private static String logFileName;
    private static PrintWriter logWriter;
    private static boolean directLoggingEnabled;

    public OUILogHandler() {
        Application.getInstance().addApplicationListener(new LogSafetyChecker());
    }

    @Override
    public void close() throws SecurityException {
        if (logWriter != null) {
            logWriter.close();
            logWriter = null;
        }
    }

    @Override
    public void flush() {
        if (logWriter != null) {
            logWriter.flush();
        }
    }

    @Override
    public Formatter getFormatter() {
        return OUI_LOG_FORMATTER;
    }

    public static File getLogFile() {
        return logFile;
    }

    public static boolean isDirectLoggingEnabled() {
        return directLoggingEnabled;
    }

    public static void setDirectLoggingEnabled(boolean enable) {
        directLoggingEnabled = enable;
        if (directLoggingEnabled) {
            File logLocation = null;
            if (OiiiInstallAreaControl.isCleanMachine()) {
                List<String> args;
                String scratchPath = System.getProperty("oracle.installer.scratchPath");
                if (scratchPath == null && (args = Application.getInstance().getArguments()) != null) {
                    for (int i = 0; i < args.size(); ++i) {
                        String argName = args.get(i);
                        if (!argName.equals("-scratchPath")) continue;
                        scratchPath = args.get(i + 1);
                    }
                }
                logLocation = new File(scratchPath);
            } else {
                OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
                String loc = apiInstaller.getDefaultLogLoc();
                if (loc != null) {
                    logLocation = new File(loc);
                }
            }
            if (logLocation != null) {
                try {
                    logFile = new File(logLocation, OUILogHandler.getLogFileName());
                    logWriter = new PrintWriter(new BufferedWriter(new FileWriter(logFile, true)));
                    LogManager.getInstance().setDefaultLogFile(logFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OUITimeLogHandler.getInstanse().setLogLocation(logLocation.getPath());
            }
        } else if (logWriter != null) {
            logWriter.close();
            logWriter = null;
        }
        OUITimeLogHandler.getInstanse().setDirectLogingEnabled(enable);
    }

    public static String getLogFileName() {
        if (logFileName == null || logFileName.length() == 0) {
            logFileName = "installActions" + OiiolLoggerUtil.getTimeStamp() + ".log";
        }
        return logFileName;
    }

    public static void setLogFileName(String logName) {
        logFileName = logName;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (super.isLoggable(record)) {
            String message = this.getFormatter().format(record);
            Throwable throwable = record.getThrown();
            if (throwable != null && !(throwable instanceof ValidationException) && !(throwable instanceof UncheckedValidationException)) {
                try {
                    StringWriter buffer = new StringWriter();
                    PrintWriter out = new PrintWriter(buffer);
                    throwable.printStackTrace(out);
                    out.close();
                    String stacktraceId = String.format("%s:%s", record.getLoggerName(), record.getSequenceNumber());
                    System.err.printf("---# Begin Stacktrace #---------------------------\nID: %s\n%s\n---# End Stacktrace #-----------------------------\n", stacktraceId, buffer.toString());
                    message = String.format("%s.\nRefer associated stacktrace #%s", message, stacktraceId);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Level level = record.getLevel();
            if (!directLoggingEnabled) {
                Integer ouiLogLevel = mapping.get(level);
                if (ouiLogLevel != null) {
                    OiiolTextLogger.appendText((String)message, (int)ouiLogLevel);
                }
            } else if (logWriter != null) {
                logWriter.printf("%s: %s\n", level.getName(), message);
                this.flush();
            }
        }
    }

    static {
        mapping.put(Level.CONFIG, OiiolTextLogger.LOG_CONFIG);
        mapping.put(Level.FINE, OiiolTextLogger.LOG_GENERAL);
        mapping.put(Level.FINER, OiiolTextLogger.LOG_DETAILED);
        mapping.put(Level.FINEST, OiiolTextLogger.LOG_TRACE);
        mapping.put(Level.INFO, OiiolTextLogger.LOG_BASIC);
        mapping.put(Level.SEVERE, OiiolTextLogger.LOG_SEVERE);
        mapping.put(Level.WARNING, OiiolTextLogger.LOG_WARNING);
    }
}

